/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Eco Web controls                 }
{ Copyright (c) 2003 - 2004 Borland Software Corporation}
{                                                       }
{*******************************************************/

using System;
using System.ComponentModel;
using System.Collections;
using System.ComponentModel.Design;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using System.Drawing.Design;
using System.Web.UI.Design;
using System.Web.UI.WebControls;
using System.Data;
//using System.Reflection;
using System.IO;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.Handles;

namespace Borland.Data.Web.Eco
{
	 #region ListBox Classes
    internal class ElementHandleListBox : System.Windows.Forms.ListBox
    {
        private IServiceProvider serviceProvider;
        private IWindowsFormsEditorService editorService;
        private ArrayList Components;
        private object FOldValue;
        private int oldColumnIndex;

        internal ElementHandleListBox(IServiceProvider serviceProvider, ComponentCollection components, object oldValue, bool bAllowNone)
        {
            this.serviceProvider = serviceProvider;
            FOldValue = oldValue;
            editorService = (IWindowsFormsEditorService) serviceProvider.GetService(typeof(IWindowsFormsEditorService));
            SelectionMode = SelectionMode.One;
            Components = new ArrayList();
            InitList(oldValue, components, bAllowNone);
            SelectedIndexChanged += new EventHandler(OnSelectionChanged);
            Click += new EventHandler(OnListClick);
            KeyDown += new KeyEventHandler(OnListKeyDown);
        }

        private void InitList(object oldValue, ComponentCollection components, bool bAllowNone)
        {
        		bool bFound = false;
            Items.Clear();
            Components.Clear();
            if( bAllowNone )
            {
            	SelectedIndex = 0;
               return;
            }
            oldColumnIndex = -1;
            if( components != null )
            {
	         	for( int i = 0; i < components.Count; i++ )
	            {
               	if( components[i] is ExpressionHandle ||
                      components[i] is OclPSHandle )
                  {
                     string sItem = components[i].ToString();
                     int iBracketPos = sItem.IndexOf('[');
                     if( iBracketPos > 0 )
                     	sItem = sItem.Substring(0, iBracketPos -1 );
	     	         	Items.Add(sItem);
                     Components.Add(components[i]);
	        	      	if( oldValue != null && components[i] == oldValue )
   	               {
         	            SelectedIndex = Components.Count -1;
      	     	   		oldColumnIndex = SelectedIndex;
            	         bFound = true;
                     }
                  }
		         }
               if( !bFound )
	            	SelectedIndex = 0;
            }
        }

        private void OnListClick(object sender, EventArgs e)
        {
            editorService.CloseDropDown();
        }

        private void OnListKeyDown(object sender, KeyEventArgs args)
        {
            if ((int)args.KeyCode == 13)
                this.OnListClick(sender, EventArgs.Empty);
        }

        private void OnSelectionChanged(object sender, EventArgs e)
        {
        }
        public int GetSelectedConnectionIndex()
        {
          return SelectedIndex;
        }

        public int OldIndex
        {
            get { return oldColumnIndex; }
        }
        public object GetSelectedObject(int index)
        {
        		return Components[index];
        }

    }

    #endregion
	#region EcoHandlesEditor
	public class EcoHandlesEditor : UITypeEditor
	{
		private ArrayList HandlesToAdd;
		private ArrayList HandlesAdded;
		private EcoHandleCollection AllHandles;

		private void InitHandles(EcoDataSource eds, ComponentCollection components)
		{
			HandlesAdded = new ArrayList();
			HandlesToAdd = new ArrayList();
			AllHandles = new EcoHandleCollection();
			if( components != null )
			{
				for( int i = 0; i < components.Count; i++ )
				{
					if( EcoHandleCollection.IsValidHandleType(components[i]) )
					{
						string Name = (components[i] as IComponent).Site.Name;
						AllHandles.Add(components[i], Name);
						if( eds.EcoHandles.IndexOf(components[i]) >= 0 )
							HandlesAdded.Add(Name);
						else
							HandlesToAdd.Add(Name);
					}
				}
			}
		}

		public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
      {
      	try
         {
            if( value is EcoHandleCollection )
            {
            	IWindowsFormsEditorService editorService = (IWindowsFormsEditorService)
					provider.GetService(typeof(IWindowsFormsEditorService));
					EcoDataSource eds = context.Instance as Borland.Data.Web.Eco.EcoDataSource;
					if( eds == null )
						return value;
					if (editorService != null && context.OnComponentChanging())
					{
						InitHandles(eds, context.Container.Components);
                  EcoHandleCollectionDlg dlg = new EcoHandleCollectionDlg(provider);
                  for( int i = 0; i < HandlesAdded.Count; i++ )
                     dlg.HandlesAddedCB.Items.Add(HandlesAdded[i]);
                  for( int i = 0; i < HandlesToAdd.Count; i++ )
                     dlg.HandlesToAddCB.Items.Add(HandlesToAdd[i]);
                  if( dlg.ShowDialog() == DialogResult.OK )
                  {
                     EcoHandleCollection ehc = value as EcoHandleCollection;
                     ehc.Clear();
							for(int i = 0; i < dlg.HandlesAddedCB.Items.Count; i++ )
							{
								int index = AllHandles.IndexOf(dlg.HandlesAddedCB.Items[i].ToString());
								ehc.Add(AllHandles[index], AllHandles.GetName(index));
							}
                  }
               }
            }
         }
         catch
         {
         }
         return value;
      }
       public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
      {
      	return UITypeEditorEditStyle.Modal;
      }
   }
   #endregion


}
